package gov.va.med.mhv.usermgmt.bizobj;

import gov.va.med.mhv.usermgmt.messages.EmployeeManagementMessages;

import java.util.List;

/**
 * Business object for the EmployeeOrganizationRole application entity
 *
 * Generated Skeleton Code
 */
 
public class EmployeeOrganizationRoleBO extends EmployeeOrganizationRoleBaseBO {
	
	protected void complexValidation() {
		validateNotRemovingLastFromRole();
		validateNotDuplicateAssignment();
	}
	
	private void validateNotRemovingLastFromRole() {
		
		//if this is an existing item we are trying to deactivate, need to make sure there is going to be
		//another user in this role at this org
		if( getId() != null && getActive() == false){
			List results = getActiveRoleAssignments( getOrganization().getId(),getRole().getId());
			
			if(results != null && results.size() < 1){
				addError(EmployeeManagementMessages.MANAGEROLES_CANT_REMOVE_LAST);
			}
		}		
	}
	
	private void validateNotDuplicateAssignment() {
		//if id is null, its a new entity, ensure its not a duplicate role assignment
		if( getId() == null) {
			EmployeeOrganizationRoleBO existingAssignment;
			
			//get all existing assignments for employee, loop over each and see if its a duplicate
			for(Object obj: getEmployeeOrganizationRolesAssignedToEmployee( getEmployee().getId())){
				existingAssignment = (EmployeeOrganizationRoleBO)obj;
				
				//if existing assignment org matches this org, and existing role matches this role, its dup
				if(existingAssignment.getOrganization().equals(this.getOrganization()) &&
				   existingAssignment.getRole().equals(this.getRole())){
					addError(EmployeeManagementMessages.MANAGEROLES_DUPLICATE_ASSIGNMENT);
					return;
				}
			}			
		}		
	}
}